	clear all,	close all, clc
	wcT = 0.065*pi; wsT = 0.075*pi; Amax = 0.1; Amin = 60; T = 1;
	M = 6; % Select M 
	% Determine the passband and stopband edge of the model filter
	wcGT = M*wcT;	Wc = (2/T)*tan(wcGT/2);	
	wsGT = M*wsT;	Ws = (2/T)*tan(wsGT/2);
	AmaxG = 10*log10(10^(0.1*Amin)/(10^(0.1*Amin)-1))
	N = 11		% Select an odd integer
	[Ga, Za, R_ZEROS, Pa, Wsnew] = CA_CONST_R_POLES_S(Wc, Ws, Amin, N);
	[G, Z, P] = PZ_2_PZ_Z(Ga, Za, Pa, T); 
	% Model filter
	figure(1), subplot(2,1,1); 
	wT = linspace(0, pi, 1000); 
	H = PZ_2_FREQ_Z(G, Z, P, wT);
	PLOT_MAG_Z_dB(wT, H, pi, 90,'H') 
	subplot(2,1,2); MwT = linspace(0, M*pi, 1000); % Periodic filter
	H_G = PZ_2_FREQ_Z(G, Z, P, MwT);
	PLOT_MAG_Z_dB(wT, H_G, pi, 90,'G_M')	
	% Masking filter
	% 	Determine the passband and stopband edges of the masking filter
	% 	Passband 				0					wcT
	% 	Stopband 1	wsT_F1 = 2*pi/M-wsT; 		wsT_F1 = 2*pi/M+wsT;
	% 	Stopband 2	wsT_F2 = 4*pi/M-wsT; 		wsT_F2 = 4*pi/M+wsT;
	% 	Stopband 3	wsT_F3 = 6*pi/M-wsT; 		wsT_F3 = pi;
	% 	
	%	AmaxG in the Cauer filer is VERY small
	%	Thus, allocate the passband ripple to the masking filter
	dc = (10^(Amax/20)-1)/(10^(Amax/20) +1)
	ds = (1+dc)/10^(Amin/20)	
	N_F = 25;		% We select an integer
	Be = [0 wcT 2*pi/M-wsT 2*pi/M+wsT 4*pi/M-wsT 4*pi/M+wsT 6*pi/M-wsT pi];
	D = [1 1 0 0 0 0 0 0]; 	W = [1 dc/ds dc/ds dc/ds ];
 	[f, ErrF] = REMEZ_FIR(N_F, Be, D, W, 'm');
	% Verify the frequency response of the FRM filter
	figure(2),%  subplot(2,1,1)
%	PLOT_MAGNITUDE_Z_dB(wT, H_G, pi, 90,'G_M')
	subplot(2,1,1), F = freqz(f, 1, 1000); 
	PLOT_MAG_Z_dB(wT, F, pi, 90, 'F')
	subplot(2,1,2), PLOT_MAG_Z_dB(wT, H_G'.*F, pi, 90, 'H')

	
